// Main.js //

var Game;

var T_Yellow = CreateColor(255, 255, 0, 80);
var Yellow = CreateColor(40, 40, 10, 125);
var T_Blue = CreateColor(0, 0, 255, 125);
var Black = CreateColor(0, 0, 0);
var T_Black = CreateColor(0, 0, 0, 125);
var T_Red = CreateColor(255, 0, 0, 125);
var debug = "";

RequireScript('RadLib/RadLib.js');

RadLib.useCursor = true;

var TurretButton = new DynaImage("TurretsButton.png");
TurretButton.onClick = function(){ Game.tab = 0; Game.showDropMenu = false; };
var SpellsButton = new DynaImage("SpellsButton.png");
SpellsButton.onClick = function(){ Game.tab = 1; Game.showDropMenu = false; };
var DownButton = new DynaImage("DownButton.png");
DownButton.onClick = function(){ if (Game.top < 2) Game.top++; Game.showDropMenu = false; };
var UpButton = new DynaImage("UpButton.png");
UpButton.onClick = function(){ if (Game.top > 0) Game.top--; Game.showDropMenu = false; };


var Cursor_Pan = LoadImage("PanCursor.png");
var Cursor_Normal = LoadImage("Cursor.png");
var GameTitle = LoadImage("Title.png");
var GameOverImage = LoadImage("Lose.png");
var GameWonImage = LoadImage("Win.png");

Cursor.image = Cursor_Normal;
Cursor.turret = null;
Cursor.turretItem = null;
Cursor.placement = false;
Cursor.move = false;
Cursor.inScreen = true;
Cursor.time = GetTime();
Cursor.a = 0;

var GameStyle = new Style()
GameStyle.window = LoadWindowStyle("Main.rws");
GameStyle.font = LoadFont("Font.rfn");

RequireScript('Enemy.js');
RequireScript('Levels.js');
RequireScript('Spells.js');
RequireScript('Timer.js');
RequireScript('Turrets.js');
RequireScript('DropMenu.js');

var DMenu = new DropMenu(GameStyle);
DMenu.w = 96;
var Cam = new Camera();
var Audio = new SoundEngine();

Audio.addPlaylist("Citadel.mp3", "Citadel");
Audio.addPlaylist("Fields of Tenerron.mp3", "Fields of Tenerron");
Audio.addPlaylist("Stranger.mp3", "Stranger");
Audio.addPlaylist("Red Fields.mp3", "Red Fields");
Audio.addPlaylist("Virtue lost.mp3", "Virtue Lost");

var Timer1 = new Timer(1000);
Timer1.onEnd = function()
{
	if (Game.waves[Game.level.wave].enemies < Game.level.max)
	{
		CreateEnemy();
		Timer1.start();
	}
}

var Timer2 = new Timer(10000);
Timer2.onEnd = function()
{
	Game.level.max++;
	Game.level.wave++;
	Game.ehp += 5+Game.level.wave*1.2;
	this.length += 2000;
	Game.waves[Game.waves.length] = {enemies: 0};
	if (Game.level.wave < Game.maxWaves) this.start();
	Timer1.start();
}

function GameData()
{
	this.life = 10;
	this.mana = 10;
	this.total = 10;
	this.maxMana = 10;
	this.tab = 0;
	this.top = 0;
	this.money = 40;
	this.ehp = 30;
	this.emoney = 2;
	this.espd = 0.5;
	this.maxWaves = 10;
	this.available = 2;
	this.waves = [];
	this.waves[0] = {enemies: 0};
	this.showDropMenu = false;
	this.layerWidth = 0;
	this.layerHeight = 0;
	
	Enemies = [];
	Bullets = [];
	Turrets = [];
	SpellEffects = [];
	Timer1.reset(1000);
	Timer2.reset(12000);
}

function MenuBG() { GameTitle.blit(0, 0); }

var g_replay = true;
function game()
{	
	Audio.play("Breaking the siege.mp3");
	PlayRadLibIntro(true);
	
	var gt = new DynaImage(GameTitle);
	gt.setFade(FADE_IN, 2000);
	while(!gt.fadeDone) {
		gt.update(2000);
		FlipScreen();
	}
	
	SetFrameRate(60);
	BindKey(KEY_ESCAPE, '', 'ShowInGameMenu();');
	var GameMenu = new Menu(SW/2-50, SH/2-14, 100, 28, GameStyle);
	GameMenu.addItem("Start Game", SetDifficulty);
	GameMenu.addItem("Quit Game", function() { g_replay = false; });
	GameMenu.preRender = MenuBG;
	while(g_replay) {
		Game = new GameData();
		GameMenu.execute();
		Audio.disablePlaylisting();
		Audio.play("Breaking the siege.mp3");
		GameMenu.done = false;
		if (Game.level) {
			Game.level.max = 4;
			Game.level.wave = 0;
		}
	}
	Audio.stop();
}

function SetDifficulty()
{
	var DiffMenu = new Menu(SW/2-60, SH/2-20, 120, 70, GameStyle);
	DiffMenu.addItem("10 waves", ShowLevelMenu);
	DiffMenu.addItem("15 waves", function(){ Game.maxWaves = 15; ShowLevelMenu(); });
	DiffMenu.addItem("20 waves", function(){ Game.maxWaves = 20; ShowLevelMenu(); });
	DiffMenu.addItem("25 waves", function(){ Game.maxWaves = 25; ShowLevelMenu(); });
	DiffMenu.addItem("100 waves", function(){ Game.maxWaves = 100; ShowLevelMenu(); });
	DiffMenu.addItem("200 waves", function(){ Game.maxWaves = 200; ShowLevelMenu(); });
	DiffMenu.addItem("Cancel", function(){});
	DiffMenu.preRender = MenuBG;
	DiffMenu.execute();
}

function ShowLevelMenu()
{
	var LevelMenu = new Menu(SW/2-50, SH/2-20, 100, 56, GameStyle);
	LevelMenu.addItem("Field", function() { Game.level = Level1; gamestart(); });
	LevelMenu.addItem("Lake", function() { Game.level = Level2; gamestart(); });
	LevelMenu.addItem("Peninsula", function() { Game.level = Level3; gamestart(); });
	LevelMenu.addItem("Valley", function() { Game.level = Level4; gamestart(); });
	LevelMenu.addItem("Oasis", function() { Game.level = Level5; gamestart(); });
	LevelMenu.addItem("Romp", function() { Game.level = Level6; gamestart(); });
	LevelMenu.addItem("Cancel", function(){});
	LevelMenu.preRender = MenuBG;
	LevelMenu.onClose = ZoomFun;
	LevelMenu.execute();
}

function gamestart()
{
	Audio.stop();
	Audio.enablePlaylisting();
	SetUpdateScript("UpdateScript();");
	SetRenderScript("RenderScript();");
	Timer2.start();
	SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "MapEntry();");
	MapEngine(Game.level.map, 60);
}

function MapEntry()
{
	Game.layerWidth = (GetLayerWidth(0)*16)-1;
	Game.layerHeight = (GetLayerHeight(0)*16)-1;
	Cam.setXY(160, 120);
	SetLayerRenderers();
}

function UpdateScript()
{
	Timer1.update();
	Timer2.update();
	UpdateTurrets();
	UpdateSpells();
	
	Cursor.inScreen = Cursor.isWithin(0, 0, SW-88, SH-68);
	
	if (Cursor.move)
	{
		Cursor.turret.x = Math.floor(Cursor.mapX/16)*16+7;
		Cursor.turret.y = Math.floor(Cursor.mapY/16)*16+7;
	}
	
	var InMenu = Cursor.isWithin(DMenu.x-4, DMenu.y-4, DMenu.w+8, DMenu.h+8);
	
	if (Cursor.isWithin(0, 0, SW-84, SH-60) && (!InMenu || !Game.showDropMenu))
	{
		if (Cursor.leftClick())
		{
			Game.showDropMenu = false;
			if (Cursor.placement && Game.money >= Cursor.turretItem.price && CanPlace(Cursor.mapX, Cursor.mapY))
			{
				PlaceTurret(Cursor.mapX, Cursor.mapY);
				Game.money -= Cursor.turretItem.price;
				if (Game.money < Cursor.turretItem.price) Cursor.placement = false;
			}
			else if (Cursor.move && CanPlace(Cursor.mapX, Cursor.mapY, true))
			{
				Cursor.move = false;
				Cursor.turret.active = true;
			}
			else if (Cursor.spell)
			{
				Cursor.spell.effect();
				if (Game.mana < Cursor.spell.cost) Cursor.spell = null;
			}
			else if (!Cursor.placement)
			{
				Cursor.turret = GetTurretAt(Cursor.mapX, Cursor.mapY);
			}
		}
	}
	
	if ((IsKeyPressed(KEY_LEFT) || Cursor.x < 2) && Cam.x > 160) Cam.setXY(Cam.x-8, Cam.y);
	if ((IsKeyPressed(KEY_RIGHT) || Cursor.x > SW-2) && Cam.x < (GetLayerWidth(0)*16)-160) Cam.setXY(Cam.x+8, Cam.y);
	if ((IsKeyPressed(KEY_UP) || Cursor.y < 2) && Cam.y > 120) Cam.setXY(Cam.x, Cam.y-8);
	if ((IsKeyPressed(KEY_DOWN) || Cursor.y > SH-2) && Cam.y < (GetLayerHeight(0)*16)-120) Cam.setXY(Cam.x, Cam.y+8);
	
	if (Cursor.rightClick() && !Cursor.move)
	{
		var e = GetClosestEnemy(Cursor.mapX, Cursor.mapY, 16);
		if (e && Cursor.turret) {
			Cursor.turret.target = e;
			return;
		}
		
		Cursor.turret = GetTurretAt(Cursor.mapX, Cursor.mapY);
		if (Cursor.placement) Cursor.placement = false;
		else if (Cursor.spell != null) Cursor.spell = null;
		else Game.showDropMenu = false;
		if (Cursor.turret != null && !Game.showDropMenu)
		{
			DMenu.items = [];
			DMenu.h = 0;
			DMenu.x = MapToScreenX(0, Cursor.turret.x+4);
			DMenu.y = MapToScreenY(0, Cursor.turret.y+4);
			
			var upgrade_name = "Upgrade " + ((Cursor.turret.level < 3) ? "$" + Cursor.turret.cost : "Max");
			
			DMenu.addItem(upgrade_name, "Upgrade();", Cursor.turret.level < 3);
			DMenu.addItem("Sell", "Sell();");
			DMenu.addItem("Move", "MoveTurret();");
			DMenu.addItem("Cancel", "Game.showDropMenu = false;");
			Game.showDropMenu = true;
			DMenu.enter();
		}
	}
	
	if (Game.mana > Game.maxMana) Game.mana = Game.maxMana;
	
	if (Game.life == 0) GameOver();
	if (Game.level.wave > Game.maxWaves) GameWin();

	Cursor.handleUnPress();
}

function CanPlace(x, y, exclude)
{
	var tile = GetTile(Math.floor(x/16), Math.floor(y/16), 0);
	var tilename = GetTileName(tile);
	return (tilename == "yes" && GetTurretAt(x, y, exclude) == null);
}

function RenderScript()
{
	UpdateEnemies();
	UpdateBullets();
	
	if (Cursor.placement && Cursor.inScreen)
	{
		var x = Math.floor(Cursor.mapX/16)*16+7;
		var y = Math.floor(Cursor.mapY/16)*16+7;
		FilledCircle(MapToScreenX(0, x), MapToScreenY(0, y), Cursor.turretItem.range, T_Yellow);
		OutlinedCircle(MapToScreenX(0, x), MapToScreenY(0, y), Cursor.turretItem.range, Yellow);
		if (CanPlace(Cursor.mapX, Cursor.mapY)) Rectangle(MapToScreenX(0, x-7), MapToScreenY(0, y-7), 16, 16, T_Blue);
		else Rectangle(MapToScreenX(0, x-7), MapToScreenY(0, y-7), 16, 16, T_Red);
	}
	
	DrawToolsPanel();
	
	// Show current spell //
	if (Cursor.spell != null)
	{
		var x = Math.floor(Cursor.mapX/16)*16;
		var y = Math.floor(Cursor.mapY/16)*16;
		if (Cursor.inScreen) OutlinedRectangle(MapToScreenX(0, x), MapToScreenY(0, y), 16, 16, T_Black);
		Cursor.spell.image.blit(Cursor.x+9, Cursor.y+11);
	}

	// Show Current Turret //
	if (Cursor.placement)
	{
		var x = Math.floor(Cursor.mapX/16)*16;
		var y = Math.floor(Cursor.mapY/16)*16;
		if (Cursor.inScreen) Cursor.turretItem.image.blit(MapToScreenX(0, x), MapToScreenY(0, y));
		else Cursor.turretItem.image.blit(Cursor.x+11, Cursor.y+9);
	}
	
	if (Game.showDropMenu) DMenu.blit();
	Audio.updatePlaylist();
	
	Cursor.draw();
}

function DrawToolsPanel()
{
	GameStyle.window.drawWindow(SW-84, 4, 80, SH-72);
	GameStyle.window.drawWindow(4, SH-64, SW-8, 60);
	TurretButton.blit(SW-72, 6);
	SpellsButton.blit(SW-40, 6);

	// Draw Next Wave //
	Rectangle(0, 0, SW-88, 14, T_Black);
	GameStyle.drawText(232, 1, "Wave: " + Game.level.wave);
	GameStyle.drawText(2, 1, "Next Wave In: ");
	Timer2.blit(100, 2);

	// Draw Current Money //
	GameStyle.drawText(6, SH-62, "Money: " + Game.money);
	
	// Draw Current Life //
	GameStyle.drawText(6, SH-48, "Life: " + Game.life + "/" + Game.total);

	// Draw Current Mana //
	GameStyle.drawText(6, SH-34, "Mana: " + Game.mana + "/" + Game.maxMana);
	
	var InMenu = Cursor.isWithin(DMenu.x-4, DMenu.y-4, DMenu.w+8, DMenu.h+8);
	
	// Draw Turrets //
	if (Game.tab == 0)
	{
		DownButton.blit(SW-72, SH-94);
		UpButton.blit(SW-40, SH-94);
		for (var i = 0; i < TurretItems.length; ++i)
		{
			if (i > Game.available) continue;
			var turret = TurretItems[i + Game.top];
			
			var pos = 32+i*57;
			
			if (Cursor.isWithin(SW-82, pos, 80, 57) && (!InMenu || !Game.showDropMenu) && !Cursor.move)
			{
				Rectangle(SW-82, pos, 76, 57, turret.price <= Game.money ? T_Black : T_Red);
				if (Cursor.leftClick())
				{
					Cursor.turretItem = turret;
					Game.showDropMenu = false;
					if (Game.money >= Cursor.turretItem.price) Cursor.placement = true, Cursor.turret = null;
				}
			}
			turret.image.blit(SW-82, pos);
			GameStyle.drawText(SW-64, 2+pos, "$: " + turret.price);
			GameStyle.drawText(SW-80, 16+pos, "Range: " + turret.range);
			GameStyle.drawText(SW-80, 30+pos, "Rate: " + turret.rate);
			GameStyle.drawText(SW-80, 44+pos, "Atk: " + turret.atk);
		}
	}
	// Draw spells //
	else
	{
		for (var i = 0; i < Spells.length; ++i)
		{
			var spell = Spells[i];
			if (Cursor.isWithin(SW-82, 32+i*34, 80, 32) && (!InMenu || !Game.showDropMenu) && !Cursor.move)
			{
				Rectangle(SW-82, 32+i*34, 76, 34, spell.cost <= Game.mana ? T_Black : T_Red);
				if (Cursor.leftClick())
				{
					Game.showDropMenu = false;
					if (Game.mana >= spell.cost) Cursor.spell = spell;
				}
			}
			GameStyle.drawText(SW-80, 32+i*34, spell.name);
			spell.image.blit(SW-80, 48+i*34);
			GameStyle.drawText(SW-62, 50+i*34, "M: " + spell.cost);
		}
	}
	
	// Show Turret Info //
	if (Cursor.turret != null)
	{
		var pos2 = SH-62;
		GameStyle.drawText(140, pos2, "Type: "  + Cursor.turret.type);
		GameStyle.drawText(240, pos2, "Level: " + Cursor.turret.level);
		GameStyle.drawText(140, pos2+14, "Range: " + Cursor.turret.range);
		GameStyle.drawText(240, pos2+14, "Kills: " + Cursor.turret.kills);
		GameStyle.drawText(140, pos2+28, "Atk: "   + Cursor.turret.atk);
		GameStyle.drawText(140, pos2+42, "Rate: "  + Cursor.turret.rate);
	}
}

function ShowTurretRadius()
{
	UpdatePulses();
	if (Cursor.turret == null) return;
	
	// Show turret radius //
	FilledCircle(MapToScreenX(0, Cursor.turret.x), MapToScreenY(0, Cursor.turret.y), Cursor.turret.range, T_Yellow);
	OutlinedCircle(MapToScreenX(0, Cursor.turret.x), MapToScreenY(0, Cursor.turret.y), Cursor.turret.range, Yellow);
	Rectangle(MapToScreenX(0, Cursor.turret.x-7), MapToScreenY(0, Cursor.turret.y-7), 16, 16, T_Black);
	
	if (Cursor.move && Cursor.inScreen)
	{
		var x = Math.floor(Cursor.mapX/16)*16+7;
		var y = Math.floor(Cursor.mapY/16)*16+7;
		if (CanPlace(Cursor.mapX, Cursor.mapY, true)) Rectangle(MapToScreenX(0, x-7), MapToScreenY(0, y-7), 16, 16, T_Blue);
		else Rectangle(MapToScreenX(0, x-7), MapToScreenY(0, y-7), 16, 16, T_Red);
	}
}

function SetLayerRenderers()
{
	SetLayerRenderer(0, "ShowTurretRadius();");
	SetLayerRenderer(1, "DrawTurrets();");
}

function ShowInGameMenu()
{
	Timer1.pause();
	Timer2.pause();
	RenderMap();
	var BG = GrabImage(0, 0, SW, SH);
	var GameMenu = new Menu(SW/2-88, SH/2-68, 100, 44, GameStyle);
	GameMenu.addItem("Return", function(){});
	GameMenu.addItem("To Main", function() { ExitMapEngine(); });
	GameMenu.addItem("Quit Game", function(){ ExitMapEngine(); g_replay = false; });
	GameMenu.preRender = function()
	{
		BG.blit(0, 0);
	}
	GameMenu.execute();
	Timer1.resume();
	Timer2.resume();
}

function ZoomFun()
{
	Bullets = [];
	var img = GrabImage(0, 0, SW, SH);
	var x = 0, y = 0, w = 0, h = 0, r = 0;
	var Color = CreateColor(0, 0, 0);
	for (var i = 1; i < 200; i += 4)
	{
		x = -(5*i); y = -(5*i);
		w = img.width+10*i; h = img.height+10*i;
		r = i/0.50;
		img.transformBlit(x, y, x+w, y, x+w, y+h, x, y+h);
		FilledComplex(0, 0, SW, SH, SW/2, SH/2, r, 0, 0, true, Colors.black, Colors.clear);
		FlipScreen();
	}
	for (var i = 0; i < 32; i += 4)
	{
		img.transformBlit(x, y, x+w, y, x+w, y+h, x, y+h);
		FilledComplex(0, 0, SW, SH, SW/2, SH/2, r, 0, 0, true, Colors.black, Colors.clear);
		Color.alpha = i*8;
		Rectangle(0, 0, SW, SH, Color);
		FlipScreen();
	}
	img.blit(0, 0);
}

function GameOver()
{
	SetFrameRate(0);
	var img = GrabImage(0, 0, SW, SH);
	while(!IsAnyKeyPressed())
	{
		img.blit(0, 0);
		GameOverImage.blit(SW/2-44-GameOverImage.width/2, SH/2-68);
		GameStyle.drawText(SW/2-44-GameStyle.font.getStringWidth("Press Any Key to Continue...")/2, SH/2-16, "Press Any Key to Continue..."); 
		FlipScreen();
	}
	ExitMapEngine();
}

function GameWin()
{
	SetFrameRate(0);
	var img = GrabImage(0, 0, SW, SH);
	while(!IsAnyKeyPressed())
	{
		img.blit(0, 0);
		GameWonImage.blit(SW/2-44-GameWonImage.width/2, SH/2-68);
		GameStyle.drawText(SW/2-44-GameStyle.font.getStringWidth("Press Any Key to Continue...")/2, SH/2-16, "Press Any Key to Continue..."); 
		FlipScreen();
	}
	ExitMapEngine();
}